( function() {
    'use strict';

    const { registerBlockType } = wp.blocks;
    const { InspectorControls } = wp.blockEditor;
    const { PanelBody, TextControl, RangeControl, ToggleControl } = wp.components;
    const { __ } = wp.i18n;
    const { createElement: el } = wp.element;

    registerBlockType( 'rms/counter', {
        edit: function( props ) {
            const { attributes, setAttributes } = props;
            const { value = 100, prefix = '', suffix = '', label = '', duration = 1200, grouping = true, reduceMotion = true } = attributes;

            return [
                el(
                    InspectorControls,
                    {},
                    el(
                        PanelBody,
                        { title: __( 'Counter Settings', 'rms' ), initialOpen: true },
                        el( RangeControl, {
                            label: __( 'Value', 'rms' ),
                            value: value,
                            min: 0,
                            max: 100000,
                            onChange: ( value ) => setAttributes({ value: Number( value ) })
                        }),
                        el( TextControl, {
                            label: __( 'Prefix', 'rms' ),
                            value: prefix,
                            onChange: ( value ) => setAttributes({ prefix: value })
                        }),
                        el( TextControl, {
                            label: __( 'Suffix', 'rms' ),
                            value: suffix,
                            onChange: ( value ) => setAttributes({ suffix: value })
                        }),
                        el( TextControl, {
                            label: __( 'Label', 'rms' ),
                            help: __( 'Visible label under the number', 'rms' ),
                            value: label,
                            onChange: ( value ) => setAttributes({ label: value })
                        }),
                        el( RangeControl, {
                            label: __( 'Duration (ms)', 'rms' ),
                            value: duration,
                            min: 0,
                            max: 5000,
                            step: 50,
                            onChange: ( value ) => setAttributes({ duration: Number( value ) })
                        }),
                        el( ToggleControl, {
                            label: __( 'Grouping (thousands separators)', 'rms' ),
                            checked: grouping,
                            onChange: ( value ) => setAttributes({ grouping: !! value })
                        }),
                        el( ToggleControl, {
                            label: __( 'Honor reduced motion', 'rms' ),
                            checked: reduceMotion,
                            onChange: ( value ) => setAttributes({ reduceMotion: !! value })
                        })
                    )
                ),
                el(
                    'div',
                    { className: 'rms-counter-editor-preview', style: { padding: '12px', border: '1px dashed #ccc', borderRadius: '6px' } },
                    el( 'div', { style: { fontSize: '2rem', fontWeight: 700 } }, `${ prefix }${ String( value ) }${ suffix }` ),
                    el( 'div', { style: { opacity: 0.8 } }, label || __( 'Counter label', 'rms' ) )
                )
            ];
        },
        save: function() {
            return null;
        }
    });
}() );
