( function() {
    'use strict';

    const { registerBlockType } = wp.blocks;
    const { InspectorControls, MediaUpload, MediaUploadCheck } = wp.blockEditor;
    const { PanelBody, TextControl, TextareaControl, SelectControl, Button } = wp.components;
    const { __ } = wp.i18n;
    const { createElement } = wp.element;

    registerBlockType( 'rms/service-card', {
        edit: function( props ) {
            const { attributes, setAttributes } = props;
            const {
                iconType,
                icon,
                imageId,
                imageUrl,
                imageAlt,
                title,
                description,
                linkUrl
            } = attributes;

            return [
                createElement( InspectorControls, {},
                    createElement( PanelBody, {
                        title: __( 'Service Card Settings', 'rms' ),
                        initialOpen: true
                    },
                        createElement( SelectControl, {
                            label: __( 'Icon Type', 'rms' ),
                            value: iconType,
                            options: [
                                { label: __( 'Emoji', 'rms' ), value: 'emoji' },
                                { label: __( 'Image', 'rms' ), value: 'image' }
                            ],
                            onChange: ( value ) => setAttributes({ iconType: value })
                        }),

                        'emoji' === iconType && createElement( TextControl, {
                            label: __( 'Icon/Emoji', 'rms' ),
                            value: icon,
                            onChange: ( value ) => setAttributes({ icon: value }),
                            help: __( 'Enter an emoji like 🚀 or icon code', 'rms' )
                        }),

                        'image' === iconType && createElement( MediaUploadCheck, {},
                            createElement( MediaUpload, {
                                onSelect: ( media ) => {
                                    setAttributes({
                                        imageId: media.id,
                                        imageUrl: media.url,
                                        imageAlt: media.alt || media.title || ''
                                    });
                                },
                                allowedTypes: [ 'image' ],
                                value: imageId,
                                render: ({ open }) => createElement( Button, {
                                    onClick: open,
                                    variant: imageUrl ? 'secondary' : 'primary'
                                }, imageUrl ? __( 'Replace Image', 'rms' ) : __( 'Select Image', 'rms' ) )
                            })
                        ),

                        'image' === iconType && imageUrl && createElement( Button, {
                            onClick: () => setAttributes({ imageId: 0, imageUrl: '', imageAlt: '' }),
                            variant: 'secondary',
                            isDestructive: true
                        }, __( 'Remove Image', 'rms' ) ),

                        createElement( TextControl, {
                            label: __( 'Title', 'rms' ),
                            value: title,
                            onChange: ( value ) => setAttributes({ title: value })
                        }),

                        createElement( TextareaControl, {
                            label: __( 'Description', 'rms' ),
                            value: description,
                            onChange: ( value ) => setAttributes({ description: value }),
                            rows: 3
                        }),

                        createElement( TextControl, {
                            label: __( 'Link URL (Optional)', 'rms' ),
                            value: linkUrl,
                            onChange: ( value ) => setAttributes({ linkUrl: value }),
                            help: __( 'Leave empty to disable link functionality', 'rms' )
                        })
                    )
                ),

                createElement( 'div', {
                    className: 'rms-card service-card rms-card--icon-top rms-card--editor-preview'
                },
                    createElement( 'div', {
                        className: 'rms-card__icon' + ( 'image' === iconType && imageUrl ? ' rms-card__icon--has-image' : '' )
                    },
                        'image' === iconType && imageUrl ?
                            createElement( 'img', {
                                src: imageUrl,
                                alt: imageAlt || title || __( 'Service Image', 'rms' ),
                                className: 'rms-card__image'
                            }) :
                            ( icon || '🚀' )
                    ),
                    createElement( 'div', {
                        className: 'rms-card__content'
                    },
                        createElement( 'h3', {
                            className: 'rms-card__title'
                        }, title || __( 'Service Title', 'rms' ) ),
                        createElement( 'p', {
                            className: 'rms-card__body'
                        }, description || __( 'Service description goes here...', 'rms' ) )
                    )
                )
            ];
        },

        save: function() {
            return null;
        }
    });
}() );
