/* eslint-disable */
( function() {
  'use strict';

  function formatNumber( n ) {
    return n.toLocaleString( undefined );
  }

  function animate( el ) {
    var value = parseFloat( el.getAttribute( 'data-value' ) || '0' );
    var duration = parseInt( el.getAttribute( 'data-duration' ) || '1200', 10 );
    var grouping = ( '1' === ( el.getAttribute( 'data-grouping' ) || '1' ) );
    var reduceMotionAttr = ( '1' === ( el.getAttribute( 'data-reduce-motion' ) || '1' ) );
    var prefersReduced = ( window.matchMedia && window.matchMedia( '(prefers-reduced-motion: reduce)' ).matches );
    var reduceMotion = reduceMotionAttr || prefersReduced;
    var valueEl = el.querySelector( '.rms-counter__value' );
    var start;
    var startVal;

    if ( ! valueEl ) {
      return;
    }

    if ( reduceMotion || 0 >= duration || 0 >= value ) {
      valueEl.textContent = grouping ? formatNumber( value ) : String( value );
      return;
    }

    start = performance.now();
    startVal = 0;

    function step( now ) {
      var t = Math.min( 1, ( now - start ) / duration );
      var eased = 1 - Math.pow( 1 - t, 3 );
      var current = Math.floor( startVal + ( value - startVal ) * eased );
      valueEl.textContent = grouping ? formatNumber( current ) : String( current );
      if ( 1 > t ) {
  requestAnimationFrame( step );
      }
    }

    requestAnimationFrame( step );
  }

  function onIntersect( entries, observer ) {
    var i;
    var entry;
    for ( i = 0; i < entries.length; i++ ) {
      entry = entries[ i ];
      if ( entry.isIntersecting ) {
        animate( entry.target );
        observer.unobserve( entry.target );
      }
    }
  }

  function init() {
    var counters = document.querySelectorAll( '.rms-counter' );
    var i;
    var j;
    var io;
    if ( ! counters.length ) {
      return;
    }
    if ( 'IntersectionObserver' in window ) {
  io = new IntersectionObserver(onIntersect, { threshold: 0.3 });
      for ( i = 0; i < counters.length; i++ ) {
  io.observe(counters[ i ]);
      }
    } else {
      for ( j = 0; j < counters.length; j++ ) {
  animate(counters[ j ]);
      }
    }
  }

  if ( 'loading' === document.readyState ) {
    document.addEventListener( 'DOMContentLoaded', init );
  } else {
    init();
  }
}() );
