<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class RMS_Theme_Updater {
    private $theme_slug;
    private $version;
    private $updater_url;

    public function __construct( $theme_slug, $version, $updater_url ) {
        $this->theme_slug  = $theme_slug;
        $this->version     = $version;
        $this->updater_url = rtrim( $updater_url, '/' );

        add_filter( 'pre_set_site_transient_update_themes', array( $this, 'check_for_update' ) );
    }

    public function check_for_update( $transient ) {
        if ( empty( $transient->checked ) ) {
            return $transient;
        }

        $remote = $this->get_remote_version();
        if ( $remote && isset( $remote['version'] ) && version_compare( $this->version, $remote['version'], '<' ) ) {
            $transient->response[ $this->theme_slug ] = array(
                'theme'       => $this->theme_slug,
                'new_version' => $remote['version'],
                'url'         => isset( $remote['url'] ) ? $remote['url'] : '',
                'package'     => isset( $remote['package'] ) ? $remote['package'] : ( isset( $remote['download_url'] ) ? $remote['download_url'] : '' ),
            );
        }
        return $transient;
    }

    private function get_remote_version() {
        $body = wp_json_encode( array(
            'slug'    => $this->theme_slug,
            'version' => $this->version,
            'type'    => 'theme',
        ) );

        $response = wp_remote_post( $this->updater_url . '/check-update', array(
            'timeout' => 30,
            'headers' => array( 'Content-Type' => 'application/json' ),
            'body'    => $body,
        ) );

        if ( is_wp_error( $response ) ) {
            return false;
        }
        $code = wp_remote_retrieve_response_code( $response );
        if ( 200 !== $code ) {
            return false;
        }
        $data = json_decode( wp_remote_retrieve_body( $response ), true );
        return is_array( $data ) ? $data : false;
    }
}
