<?php
/**
 * Template helper functions wrapping multilingual content methods.
 *
 * @package RMS
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Get translated content.
 *
 * @param string      $key  Content key.
 * @param string|null $lang Language code.
 * @return string Content value.
 */
function rms_get_content( $key, $lang = null ) {
	return RMS_Multilingual_Content::get_content( $key, $lang );
}

/**
 * Get service cards for current language.
 *
 * @param string|null $lang Language code.
 * @return array Cards.
 */
function rms_get_service_cards( $lang = null ) {
	return RMS_Multilingual_Content::get_service_cards( $lang );
}

/**
 * Display translated content.
 *
 * @param string      $key  Content key.
 * @param string|null $lang Language code.
 * @return void
 */
function rms_content( $key, $lang = null ) {
	echo esc_html( rms_get_content( $key, $lang ) );
}
