<?php
/**
 * Hero Section Block Pattern
 * Frontend Development Agent
 *
 * @package RMS
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Register Hero Section block pattern.
 */
function rms_register_hero_pattern() {
	register_block_pattern(
		'rms/hero-section',
		array(
			'title'       => __( 'Hero Section', 'rms' ),
			'description' => __( 'A hero section with background image, heading, and call-to-action button. Use this to create an impactful homepage banner.', 'rms' ),
			'categories'  => array( 'header', 'featured' ),
			'keywords'    => array( 'hero', 'banner', 'header', 'cta', 'call-to-action' ),
			'content'     => '<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"0","bottom":"0"}}},"className":"hero-section"} -->
<div class="wp-block-group alignfull hero-section" style="padding-top:0;padding-bottom:0;min-height:80vh;overflow:hidden;">
    <!-- wp:columns {"align":"wide"} -->
    <div class="wp-block-columns alignwide">
        <!-- wp:column {"verticalAlignment":"center","width":"60%"} -->
        <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:60%">
            <!-- wp:heading {"level":1,"fontSize":"x-large","textAlign":"center","style":{"color":{"text":"#fff"}}} -->
            <h1 class="wp-block-heading has-x-large-font-size" style="color:#fff;text-align:center;">Welcome to Our Amazing Service</h1>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"fontSize":"large","align":"center","style":{"color":{"text":"#fff"}}} -->
            <p class="has-large-font-size" style="color:#fff;text-align:center;">Transform your business with our innovative solutions designed to help you succeed in today\'s competitive market.</p>
            <!-- /wp:paragraph -->

            <!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
            <div class="wp-block-buttons" style="justify-content:center;">
                <!-- wp:button {"backgroundColor":"white","textColor":"primary","style":{"spacing":{"padding":{"left":"2.5rem","right":"2.5rem","top":"0.75rem","bottom":"0.75rem"}},"border":{"radius":"12px"},"typography":{"fontWeight":"700","fontSize":"1.1rem"}}} -->
                <div class="wp-block-button"><a class="wp-block-button__link has-primary-color has-white-background-color has-text-color has-background wp-element-button" style="padding-top:0.75rem;padding-right:2.5rem;padding-bottom:0.75rem;padding-left:2.5rem;border-radius:12px;font-weight:700;font-size:1.1rem;">Get Started Today</a></div>
                <!-- /wp:button -->
            </div>
            <!-- /wp:buttons -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"width":"40%"} -->
        <div class="wp-block-column" style="flex-basis:40%">
            <!-- wp:image {"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"20px"}}} -->
            <figure class="wp-block-image size-large"><img src="' . esc_url( get_template_directory_uri() . '/assets/images/hero-placeholder.jpg' ) . '" alt="' . esc_attr__( 'Hero image showing our service in action', 'rms' ) . '" style="border-radius:20px;"/></figure>
            <!-- /wp:image -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
            <!-- /wp:group -->',
		)
	);
}

/**
 * Register Feature Cards block pattern.
 */
function rms_register_features_pattern() {
	register_block_pattern(
		'rms/feature-cards',
		array(
			'title'       => __( 'Feature Cards', 'rms' ),
			'description' => __( 'A set of three feature cards with icons, headings, and descriptions', 'rms' ),
			'content'     => '<!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide">
    <!-- wp:heading {"textAlign":"center","fontSize":"large"} -->
    <h2 class="wp-block-heading has-text-align-center has-large-font-size">Our Key Features</h2>
    <!-- /wp:heading -->

    <!-- wp:columns {"align":"wide"} -->
    <div class="wp-block-columns alignwide">
        <!-- wp:column -->
        <div class="wp-block-column">
            <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"8px"}},"backgroundColor":"white","className":"feature-card","layout":{"type":"constrained"}} -->
            <div class="wp-block-group feature-card has-white-background-color has-background" style="border-radius:8px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
                <!-- wp:heading {"textAlign":"center","level":3} -->
                <h3 class="wp-block-heading has-text-align-center">Fast Performance</h3>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center"} -->
                <p class="has-text-align-center">Lightning-fast loading times and optimized performance for the best user experience.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column -->
        <div class="wp-block-column">
            <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"8px"}},"backgroundColor":"white","className":"feature-card","layout":{"type":"constrained"}} -->
            <div class="wp-block-group feature-card has-white-background-color has-background" style="border-radius:8px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
                <!-- wp:heading {"textAlign":"center","level":3} -->
                <h3 class="wp-block-heading has-text-align-center">Secure & Reliable</h3>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center"} -->
                <p class="has-text-align-center">Enterprise-grade security and 99.9% uptime guarantee for peace of mind.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column -->
        <div class="wp-block-column">
            <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"8px"}},"backgroundColor":"white","className":"feature-card","layout":{"type":"constrained"}} -->
            <div class="wp-block-group feature-card has-white-background-color has-background" style="border-radius:8px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
                <!-- wp:heading {"textAlign":"center","level":3} -->
                <h3 class="wp-block-heading has-text-align-center">24/7 Support</h3>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center"} -->
                <p class="has-text-align-center">Round-the-clock customer support from our team of dedicated experts.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->',
			'categories'  => array( 'featured', 'services' ),
			'keywords'    => array( 'features', 'cards', 'services', 'grid' ),
		)
	);
}

// Register patterns on init.
add_action( 'init', 'rms_register_hero_pattern' );
add_action( 'init', 'rms_register_features_pattern' );
