<?php
/**
 * Title: Stats Counter
 * Slug: rms/stats-counter
 * Categories: featured, text
 * Description: Accessible, localized stats/counter section with four items and count-up animation.
 * Keywords: stats, counter, numbers, achievements
 *
 * @package RMS
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Gather localized content.
$lang        = function_exists( 'pll_current_language' ) ? pll_current_language() : 'en';
$stats_title = class_exists( 'RMS_Multilingual_Content' ) ? RMS_Multilingual_Content::get_content( 'stats_title', $lang ) : __( 'Our Impact in Numbers', 'rms' );
$items       = class_exists( 'RMS_Multilingual_Content' ) ? RMS_Multilingual_Content::get_content( 'stats_items', $lang ) : array();

// Fallback items if none provided.
if ( empty( $items ) || ! is_array( $items ) ) {
	$items = array(
		array(
			'label'  => __( 'Trainees', 'rms' ),
			'value'  => 12000,
			'suffix' => '+',
		),
		array(
			'label'  => __( 'Trainers', 'rms' ),
			'value'  => 350,
			'suffix' => '+',
		),
		array(
			'label'  => __( 'International Partners', 'rms' ),
			'value'  => 25,
			'suffix' => '+',
		),
		array(
			'label'  => __( 'Excellence Achieved', 'rms' ),
			'value'  => 98,
			'suffix' => '%',
		),
	);
}

// Build the counters columns using rms/counter block.
$columns_markup = '';
foreach ( $items as $item ) {
	$value  = isset( $item['value'] ) ? (int) $item['value'] : 0;
	$label  = isset( $item['label'] ) ? $item['label'] : '';
	$suffix = isset( $item['suffix'] ) ? $item['suffix'] : '';

	$block_json = wp_json_encode(
		array(
			'value'    => $value,
			'suffix'   => (string) $suffix,
			'label'    => (string) $label,
			'duration' => 1500,
		)
	);

	$columns_markup .= "\n<!-- wp:column {\"className\":\"rms-stat\"} -->\n<div class=\"wp-block-column rms-stat\">\n\t<!-- wp:rms/counter $block_json /-->\n</div>\n<!-- /wp:column -->";
}

// Output the full pattern markup.
$pattern_markup = '<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"3rem","bottom":"3rem"}}},"backgroundColor":"primary-dark","className":"rms-stats"} -->
<div class="wp-block-group alignfull has-primary-dark-background-color has-background rms-stats" style="padding-top:3rem;padding-bottom:3rem">
	<!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignwide">
		<!-- wp:heading {"textAlign":"center","level":2,"style":{"typography":{"fontWeight":"800"}}} -->
		<h2 class="wp-block-heading has-text-align-center">' . esc_html( $stats_title ) . '</h2>
		<!-- /wp:heading -->

		<!-- wp:spacer {"height":"20px"} -->
		<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
		<!-- /wp:spacer -->

		<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":"2rem"}}} -->
		<div class="wp-block-columns alignwide">
			' . $columns_markup . '
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->';

echo wp_kses_post( $pattern_markup );
