# RMS Certificate Verification

A lightweight WordPress plugin to verify certificates by number.

- Admin page to add certificate records
- REST API endpoint to verify numbers
- Shortcode to render an accessible verification form on any page

## Install
1. Copy the `rms-certificate-verification` folder to `wp-content/plugins/`
2. In WordPress Admin → Plugins, activate “RMS Certificate Verification”
3. On first activation, a table `{prefix}rms_certificates` will be created

## Usage
### Add certificates
- Go to Admin → Certificates
- Add a certificate number and optional name/program/issued date; click Save

### Frontend form
- Create a page and add the shortcode:
  - `[rms_verify_certificate]`
- Users can enter a certificate number; results show immediately

### REST API
- Public endpoint: `GET /wp-json/rms-cv/v1/verify?number=YOUR_NUMBER`
- Response when found:
```json
{
  "ok": true,
  "data": { "cert_number": "BSC22222", "name": "John Doe", "program": "MBA", "issued_on": "2024-12-01" }
}
```
- Response when not found:
```json
{ "ok": false, "error": "Not found" }
```

## Notes
- The shortcode enqueues its own minimal CSS/JS only when used
- The form uses `aria-live` for screen reader announcements
- All outputs are escaped; inputs sanitized; DB queries prepared

## Optional enhancements
- CSV import/export
- Gutenberg block for the verify form
- Audit log and rate limiting
- Custom result template with more fields
