(function(){
  'use strict';
  function onReady(fn){ if(document.readyState!=='loading'){ fn(); } else { document.addEventListener('DOMContentLoaded', fn); } }
  onReady(function(){
    document.querySelectorAll('.rms-cv-form').forEach(function(form){
      var endpoint = form.getAttribute('data-endpoint');
      var input = form.querySelector('input[name="number"]');
      var status = form.querySelector('.rms-cv-status');
      var submitBtn = form.querySelector('button[type="submit"]');
      var btnText = submitBtn ? submitBtn.querySelector('.btn-text') : null;
      var field = form.querySelector('.form-field');
      var fieldError = form.querySelector('#rms-cv-error');

      function setLoading(loading){
        if(!submitBtn) return;
          if(loading){
            form.classList.add('loading');
            submitBtn.disabled = true;
            if(btnText){ btnText.textContent = (window.RMS_CV_I18N && RMS_CV_I18N.checking) || 'Checking…'; }
          } else {
            form.classList.remove('loading');
            submitBtn.disabled = false;
            if(btnText){ btnText.textContent = (window.RMS_CV_I18N && RMS_CV_I18N.verify) || 'Verify'; }
          }
      }

      function clearStatus(){
        status.textContent = '';
        status.className = 'rms-cv-status';
        if(fieldError){ fieldError.textContent = ''; }
        if(field){ field.classList.remove('invalid','valid'); }
      }

      form.addEventListener('submit', function(e){
        e.preventDefault();
        var number = (input.value || '').trim();
        clearStatus();
        if(!number){
          if(field){ field.classList.add('invalid'); }
          if(fieldError){ fieldError.textContent = (window.RMS_CV_I18N && RMS_CV_I18N.please_enter_number) || 'Please enter a certificate number.'; }
          input.focus();
          return;
        }
        var url = endpoint + '?number=' + encodeURIComponent(number);
  setLoading(true);
  status.textContent = (window.RMS_CV_I18N && RMS_CV_I18N.checking) || 'Checking…';
        fetch(url, { headers: { 'X-WP-Nonce': window.RMS_CV_NONCE || '' } })
          .then(function(r){ return r.json().then(function(j){ return { ok:r.ok, status:r.status, body:j }; }); })
          .then(function(res){
            setLoading(false);
            if(res.ok && res.body && res.body.ok){
              var d = res.body.data || {};
              var fullName = [d.first_name, d.last_name].filter(Boolean).join(' ');
              var rows = [];
              if(d.cert_number){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.number) || 'Certificate Number', escapeHtml(d.cert_number)]); }
              if(fullName){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.name) || 'Name', escapeHtml(fullName)]); }
              if(d.field_of_study){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.field_of_study) || 'Field of Study', escapeHtml(d.field_of_study)]); }
              if(d.course_category){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.course_category) || 'Course Category', escapeHtml(d.course_category)]); }
              // ISO standards as chips
              var isoChipsHtml = '';
                if(d.iso_standards){
                  var isoParts = String(d.iso_standards).split(/[,\n]/).map(function(s){ return s.trim(); }).filter(Boolean);
                  if(isoParts.length){
                    isoChipsHtml = '<div class="rms-cv-chips">' + isoParts.map(function(s){ return '<span class="rms-cv-chip">' + escapeHtml(s) + '</span>'; }).join('') + '</div>';
                    rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.iso_standards) || 'ISO Standards', isoChipsHtml]);
                  }
              }
              if(d.exam_date){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.exam_date) || 'Exam Date', escapeHtml(d.exam_date)]); }
              if(d.issued_on){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.issue_date) || 'Issue Date', escapeHtml(d.issued_on)]); }
              if(d.exam_result){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.result) || 'Result', escapeHtml(d.exam_result)]); }
              if(d.notes){ rows.push([(window.RMS_CV_I18N && RMS_CV_I18N.notes) || 'Notes', escapeHtml(d.notes)]); }

              var tableRowsHtml = rows.map(function(pair){
                return '<tr><th scope="row">' + pair[0] + '</th><td>' + pair[1] + '</td></tr>';
              }).join('');

              // Dynamic status styling based on exam result
              var resultLower = (d.exam_result || '').toString().toLowerCase();
              var resultStatus = 'pass'; // default
              var bannerClass = 'rms-cv-banner--success';
              var tagClass = 'rms-cv-tag--success';
              var iconSymbol = '✓';

              // Determine result status
              if (resultLower === ((window.RMS_CV_I18N && RMS_CV_I18N.pass && RMS_CV_I18N.pass.toLowerCase()) || 'pass')) {
                resultStatus = 'pass';
                bannerClass = 'rms-cv-banner--success';
                tagClass = 'rms-cv-tag--success';
                iconSymbol = '✓';
              } else if (resultLower === ((window.RMS_CV_I18N && RMS_CV_I18N.fail && RMS_CV_I18N.fail.toLowerCase()) || 'fail')) {
                resultStatus = 'fail';
                bannerClass = 'rms-cv-banner--error';
                tagClass = 'rms-cv-tag--fail';
                iconSymbol = '✗';
              } else if (resultLower === ((window.RMS_CV_I18N && RMS_CV_I18N.pending && RMS_CV_I18N.pending.toLowerCase()) || 'pending')) {
                resultStatus = 'pending';
                bannerClass = 'rms-cv-banner--pending';
                tagClass = 'rms-cv-tag--pending';
                iconSymbol = '⏳';
              } else {
                resultStatus = 'neutral';
                bannerClass = 'rms-cv-banner--success';
                tagClass = 'rms-cv-tag--neutral';
                iconSymbol = '✓';
              }

              var tagText = d.exam_result || ((window.RMS_CV_I18N && RMS_CV_I18N.verified) || 'Verified');

              var bannerHtml = '<div class="rms-cv-banner ' + bannerClass + '" data-result="' + resultStatus + '" tabindex="-1" role="status">'
                + '<span class="rms-cv-banner__icon" data-result="' + resultStatus + '" aria-hidden="true">' + iconSymbol + '</span>'
                + '<div class="rms-cv-banner__content">'
                +   '<strong>' + ((window.RMS_CV_I18N && RMS_CV_I18N.certificate_verified) || 'Certificate verified') + '</strong> '
                +   '<span class="rms-cv-tag ' + tagClass + '" data-result="' + resultStatus + '">' + escapeHtml(tagText) + '</span>'
                +   (d.cert_number ? '<div class="rms-cv-banner__sub">' + ((window.RMS_CV_I18N && RMS_CV_I18N.number) || 'Number') + ': ' + escapeHtml(d.cert_number) + '</div>' : '')
                + '</div>'
              + '</div>';

              var cardHtml = '<div class="rms-cv-card">'
                + '<table class="rms-cv-table">'
                  + '<caption>' + ((window.RMS_CV_I18N && RMS_CV_I18N.verification_result) || 'Verification result') + '</caption>'
                  + '<tbody>' + tableRowsHtml + '</tbody>'
                + '</table>'
              + '</div>';

              status.innerHTML = bannerHtml + cardHtml;
              status.className = 'rms-cv-status rms-cv-status--success';
              if(field){ field.classList.remove('invalid'); field.classList.add('valid'); }
              // Move focus to banner for immediate announcement
              var banner = status.querySelector('.rms-cv-banner');
              if(banner && banner.focus){ banner.focus(); }
            } else {
              status.innerHTML = '<div class="rms-cv-banner rms-cv-banner--error" tabindex="-1" role="status">'
                + '<span class="rms-cv-banner__icon" aria-hidden="true">!</span>'
                + '<div class="rms-cv-banner__content">'
                +   '<strong>' + ((window.RMS_CV_I18N && RMS_CV_I18N.not_found) || 'Not found') + '</strong>'
                +   '<div class="rms-cv-banner__sub">' + ((window.RMS_CV_I18N && RMS_CV_I18N.no_certificate) || 'No certificate with this number. Please check the number and try again.') + '</div>'
                + '</div>'
              + '</div>';
              status.className = 'rms-cv-status rms-cv-status--error';
              if(field){ field.classList.add('invalid'); }
              var eb = status.querySelector('.rms-cv-banner');
              if(eb && eb.focus){ eb.focus(); }
            }
          })
          .catch(function(){
            setLoading(false);
            status.textContent = (window.RMS_CV_I18N && RMS_CV_I18N.network_error) || 'Network error. Please try again.';
            status.className = 'rms-cv-status rms-cv-status--error';
            if(field){ field.classList.add('invalid'); }
          });
      });
    });
  });

  function escapeHtml(str){
    return String(str).replace(/[&<>"]+/g, function(s){
      return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'}[s]);
    });
  }

})();
