<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class RMS_Plugin_Updater {
	private $plugin_slug;
	private $plugin_file;
	private $version;
	private $updater_url;

	public function __construct( $plugin_file, $plugin_slug, $version, $updater_url ) {
		$this->plugin_file = $plugin_file;
		$this->plugin_slug = $plugin_slug;
		$this->version     = $version;
		$this->updater_url = rtrim( $updater_url, '/' );

		add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'check_for_update' ) );
		add_filter( 'plugins_api', array( $this, 'plugin_api_call' ), 10, 3 );
	}

	public function check_for_update( $transient ) {
		if ( empty( $transient->checked ) ) {
			return $transient;
		}

		$remote = $this->get_remote_version();
		if ( $remote && isset( $remote['version'] ) && version_compare( $this->version, $remote['version'], '<' ) ) {
			$transient->response[ $this->plugin_file ] = (object) array(
				'slug'         => $this->plugin_slug,
				'plugin'       => $this->plugin_file,
				'new_version'  => $remote['version'],
				'url'          => isset( $remote['url'] ) ? $remote['url'] : '',
				'package'      => isset( $remote['package'] ) ? $remote['package'] : ( isset( $remote['download_url'] ) ? $remote['download_url'] : '' ),
				'tested'       => isset( $remote['tested'] ) ? $remote['tested'] : '',
				'requires_php' => isset( $remote['requires_php'] ) ? $remote['requires_php'] : '',
			);
		}

		return $transient;
	}

	public function plugin_api_call( $result, $action, $args ) {
		if ( 'plugin_information' !== $action || empty( $args->slug ) || $args->slug !== $this->plugin_slug ) {
			return $result;
		}

		$remote = $this->get_remote_version();
		if ( ! $remote ) {
			return $result;
		}

		return (object) array(
			'slug'          => $this->plugin_slug,
			'plugin'        => $this->plugin_file,
			'name'          => isset( $remote['name'] ) ? $remote['name'] : $this->plugin_slug,
			'author'        => isset( $remote['author'] ) ? $remote['author'] : 'RMS',
			'homepage'      => isset( $remote['url'] ) ? $remote['url'] : '',
			'Version'       => $remote['version'],
			'requires'      => isset( $remote['requires'] ) ? $remote['requires'] : '',
			'tested'        => isset( $remote['tested'] ) ? $remote['tested'] : '',
			'requires_php'  => isset( $remote['requires_php'] ) ? $remote['requires_php'] : '',
			'download_link' => isset( $remote['package'] ) ? $remote['package'] : '',
			'sections'      => isset( $remote['sections'] ) && is_array( $remote['sections'] ) ? $remote['sections'] : array(),
			'banners'       => isset( $remote['banners'] ) ? $remote['banners'] : array(),
			'icons'         => isset( $remote['icons'] ) ? $remote['icons'] : array(),
		);
	}

	private function get_remote_version() {
		$body = wp_json_encode( array(
			'slug'    => $this->plugin_slug,
			'version' => $this->version,
			'type'    => 'plugin',
		) );

		$response = wp_remote_post( $this->updater_url . '/check-update', array(
			'timeout' => 30,
			'headers' => array( 'Content-Type' => 'application/json' ),
			'body'    => $body,
		) );

		if ( is_wp_error( $response ) ) {
			return false;
		}

		$code = wp_remote_retrieve_response_code( $response );
		if ( 200 !== $code ) {
			return false; // 204 means no update.
		}

		$data = json_decode( wp_remote_retrieve_body( $response ), true );
		return is_array( $data ) ? $data : false;
	}
}
